﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.TBI;
using System.Text;
using System.Data;
using Telerik.Web.UI;
using xi = Telerik.Web.UI.ExportInfrastructure;
using Telerik.Web.UI.GridExcelBuilder;

public partial class ADHocReporting : System.Web.UI.Page
{
    
    #region Variable Declarations

    private UserAccountManager _currentUser;

    private const string GET_INSTRUMENT_TYPES = "tbi.usp_GetInstrumentTypes";
    private const string GET_FISCAL_YEARS = "tbi.usp_GetFiscalYears";
    private const string GET_SURVEYS = "[tbi].usp_Get_Surveys";
    private const string GET_FACILITIES = "tbi.usp_Get_Facilities";
    //private const string fn_GET_FQ_FIRST_DAY = "dbo.GetFirstDayOfFiscalQuarter";
    //private const string fn_GET_FQ_LAST_DAY = "dbo.GetLastDayOfFiscalQuarter";
    //private const string GET_FQ_FIRST_DAY = "TBI.GetFirstDayOfFiscalQuarter";
    //private const string GET_FQ_LAST_DAY = "TBI.GetLastDayOfFiscalQuarter";
    private const string GET_NUMBER_OF_SURVEYS = "TBI.usp_GetNumberOfSurveys";


    int FY;
    int surveyType;
    ArrayList selectedFQs;
    bool blnDetailsByMonth;
    string strSkin;
    DataTable dtSurveys;
    RadGrid grdDynamic;

    #endregion

    protected void Page_Load(object sender, EventArgs e) {
        if (!AccessAllowed()) {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
        //lblError.Text = "";

        //grdSurveys.Visible = false;
        //grdSurveys_ST8.Visible = false;
        //grdSurveys_ST10.Visible = false;

        if (!IsPostBack) {
            //try {
            //    ddlTBIInstruments.DataSource = GetInstrumentTypes();
            //    ddlTBIInstruments.DataValueField = "ID";
            //    ddlTBIInstruments.DataTextField = "Name";
            //    ddlTBIInstruments.DataBind();
            //    ddlTBIInstruments.Items.Insert(0, new ListItem("Select Instrument Type", "0"));

            //    ddlFY.DataSource = GetFiscalYears();
            //    ddlFY.DataValueField = "FY";
            //    ddlFY.DataTextField = "FY";
            //    ddlFY.DataBind();
            //    ddlFY.Items.Insert(0, new ListItem("Select FY", "-1"));
            //} catch (Exception ex) {
            //    //Exception _tbilogerror = HandleTBIException(ex, "tbireports.aspx", "100006", "DropDownList-DataBind()");
            //}
        }
    }

    private bool AccessAllowed() {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return (_currentUser.IsInRole(16) || _currentUser.IsInRole(17) || _currentUser.IsInRole(18) || _currentUser.IsInRole(413) || _currentUser.IsInRole(417));
    }

    protected void ddlTBIInstruments_SelectedIndexChanged(object sender, EventArgs e) {
        //if (ddlTBIInstruments.SelectedIndex == 0) return;
        //lblReportTitle.Text = "TBI Instrument Report: " + ddlTBIInstruments.SelectedItem.Text;
        //lblReportTitle.Visible = true;
        //lnkbtnChangeReportType.Visible = true;
        //pnlReportSelection.Visible = false;
        //pnlReports.Visible = true;
        //pnlReportCriteria.Visible = true;
        //pnlReportGrid.Visible = false;

        //int surveyType;
        //int.TryParse(ddlTBIInstruments.SelectedValue, out surveyType);
        //if ((surveyType == 8) || (surveyType == 10)) {
        //    chbxDetailsByMonth.Visible = false;
        //    trDisplayMode.Visible = false;
        //}
        //else
        //{
        //    chbxDetailsByMonth.Visible = true;
        //    trDisplayMode.Visible = true;
        //}
    }

    protected void lnkbtnChangeReportType_Click(object sender, EventArgs e) {
        //pnlReportSelection.Visible = true;
        //lnkbtnChangeReportType.Visible = false;
        //pnlReports.Visible = false;
    }

    protected void btnRun_Click(object sender, EventArgs e) {
        GenerateReport();
    }

    private void GenerateReport()
    {
        ////int.TryParse(ddlFY.SelectedValue, out FY);
        ////int.TryParse(ddlTBIInstruments.SelectedValue, out surveyType);
        ////strSkin = ddlSkin.SelectedValue;
        ////blnDetailsByMonth = chbxDetailsByMonth.Checked;
        ////selectedFQs = new ArrayList();
        ////foreach (ListItem item in chbxlistFiscalQuarters.Items)
        ////{
        ////    if (item.Selected)
        ////    {
        ////        selectedFQs.Add(item.Value);
        ////    }
        ////}
        ////dtSurveys = GetSurveysData(surveyType);

        ////if (dtSurveys != null && dtSurveys.Rows.Count > 0)
        ////{
        ////    pnlReports.Visible = true;
        ////    pnlReportCriteria.Visible = true;
        ////    pnlReportGrid.Visible = true;
        ////    CreateDynamicGrid();







            //if ((surveyType != 8) && (surveyType != 10))  //&& (surveyType != 11) && (surveyType != 15) && (surveyType != 19)
            //{
            //    grdSurveys.DataSource = dtSurveys;
            //    grdSurveys.DataBind();
            //    grdSurveys.Visible = true;
            //    grdSurveys.Skin = strSkin;
            //}
            //else if (surveyType == 8)
            //{
            //    grdSurveys_ST8.DataSource = dtSurveys;
            //    grdSurveys_ST8.DataBind();
            //    grdSurveys_ST8.Visible = true;
            //    grdSurveys_ST8.Skin = strSkin;
            //}
            //else if (surveyType == 10)
            //{
            //    grdSurveys_ST10.DataSource = dtSurveys;
            //    grdSurveys_ST10.DataBind();
            //    grdSurveys_ST10.Visible = true;
            //    grdSurveys_ST10.Skin = strSkin;
            












    //    }
    //    else
    //    {
    //        pnlReports.Visible = true;
    //        pnlReportCriteria.Visible = true;
    //        pnlReportGrid.Visible = false;
    //        lblError.Text = "0 records found";
    //    }
  }






    /*private void CreateDynamicGrid_v1()  // STATIC GRIDS
    {
        grdDynamic = new RadGrid();
        grdDynamic.ID = "grdDynamic";
        grdDynamic.MasterTableView.EnableColumnsViewState = false;
        grdDynamic.Skin = strSkin;
        grdDynamic.AutoGenerateColumns = false;
        grdDynamic.GroupingEnabled = true;
        grdDynamic.ShowFooter = true;
        grdDynamic.ShowGroupPanel = false;
        grdDynamic.Visible = true;
        grdDynamic.Width = Unit.Percentage(100);

        GridColumnGroup cg;
        cg = new GridColumnGroup();
        cg.Name = "FQs";
        cg.HeaderText = "Fiscal Quarters";
        cg.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
        grdDynamic.MasterTableView.ColumnGroups.Add(cg);

        if (selectedFQs.Contains("1") && (blnDetailsByMonth))
        {
            cg = new GridColumnGroup();
            cg.Name = "FQ1";
            cg.HeaderText = "FQ1";
            cg.ParentGroupName = "FQs";
            cg.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            grdDynamic.MasterTableView.ColumnGroups.Add(cg);
        }

        if (selectedFQs.Contains("2") && (blnDetailsByMonth))
        {
            cg = new GridColumnGroup();
            cg.Name = "FQ2";
            cg.HeaderText = "FQ2";
            cg.ParentGroupName = "FQs";
            cg.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            grdDynamic.MasterTableView.ColumnGroups.Add(cg);
        }

        if (selectedFQs.Contains("3") && (blnDetailsByMonth))
        {
            cg = new GridColumnGroup();
            cg.Name = "FQ3";
            cg.HeaderText = "FQ3";
            cg.ParentGroupName = "FQs";
            cg.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            grdDynamic.MasterTableView.ColumnGroups.Add(cg);
        }

        if (selectedFQs.Contains("4") && (blnDetailsByMonth))
        {
            cg = new GridColumnGroup();
            cg.Name = "FQ4";
            cg.HeaderText = "FQ4";
            cg.ParentGroupName = "FQs";
            cg.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            grdDynamic.MasterTableView.ColumnGroups.Add(cg);
        }

        GridBoundColumn boundColumn;

        boundColumn = new GridBoundColumn();
        grdDynamic.MasterTableView.Columns.Add(boundColumn);
        boundColumn.DataField = "Facility";
        boundColumn.HeaderText = "Facility";
        boundColumn.Aggregate = GridAggregateFunction.Count;
        boundColumn.FooterAggregateFormatString = "Total: {0}";
        boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Left;

        if (selectedFQs.Contains("1"))
        {
            if (blnDetailsByMonth)
            {
                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FM1";
                boundColumn.HeaderText = "Oct";
                boundColumn.ColumnGroupName = "FQ1";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FM2";
                boundColumn.HeaderText = "Nov";
                boundColumn.ColumnGroupName = "FQ1";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FM3";
                boundColumn.HeaderText = "Dec";
                boundColumn.ColumnGroupName = "FQ1";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
            }

            boundColumn = new GridBoundColumn();
            grdDynamic.MasterTableView.Columns.Add(boundColumn);
            boundColumn.DataField = "FQ1";
            boundColumn.HeaderText = "FQ1";
            if (blnDetailsByMonth)
            {
                boundColumn.ColumnGroupName = "FQ1";
            }
            else
            {
                boundColumn.ColumnGroupName = "FQs";
            }
            boundColumn.Aggregate = GridAggregateFunction.Sum;
            boundColumn.FooterAggregateFormatString = "{0}";
            boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
            boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
        }

        if (selectedFQs.Contains("2"))
        {
            if (blnDetailsByMonth)
            {
                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FM4";
                boundColumn.HeaderText = "Jan";
                boundColumn.ColumnGroupName = "FQ2";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FM5";
                boundColumn.HeaderText = "Feb";
                boundColumn.ColumnGroupName = "FQ2";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FM6";
                boundColumn.HeaderText = "Mar";
                boundColumn.ColumnGroupName = "FQ2";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
            }
            boundColumn = new GridBoundColumn();
            grdDynamic.MasterTableView.Columns.Add(boundColumn);
            boundColumn.DataField = "FQ2";
            boundColumn.HeaderText = "FQ2";
            if (blnDetailsByMonth)
            {
                boundColumn.ColumnGroupName = "FQ2";
            }
            else
            {
                boundColumn.ColumnGroupName = "FQs";
            }
            boundColumn.Aggregate = GridAggregateFunction.Sum;
            boundColumn.FooterAggregateFormatString = "{0}";
            boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
            boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
        }

        if (selectedFQs.Contains("3"))
        {
            if (blnDetailsByMonth)
            {
                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FM7";
                boundColumn.HeaderText = "Apr";
                boundColumn.ColumnGroupName = "FQ3";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FM8";
                boundColumn.HeaderText = "May";
                boundColumn.ColumnGroupName = "FQ3";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FM9";
                boundColumn.HeaderText = "Jun";
                boundColumn.ColumnGroupName = "FQ3";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
            }
            boundColumn = new GridBoundColumn();
            grdDynamic.MasterTableView.Columns.Add(boundColumn);
            boundColumn.DataField = "FQ3";
            boundColumn.HeaderText = "FQ3";
            if (blnDetailsByMonth)
            {
                boundColumn.ColumnGroupName = "FQ3";
            }
            else
            {
                boundColumn.ColumnGroupName = "FQs";
            }
            boundColumn.Aggregate = GridAggregateFunction.Sum;
            boundColumn.FooterAggregateFormatString = "{0}";
            boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
            boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
        }

        if (selectedFQs.Contains("4"))
        {
            if (blnDetailsByMonth)
            {
                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FM10";
                boundColumn.HeaderText = "Jul";
                boundColumn.ColumnGroupName = "FQ4";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FM11";
                boundColumn.HeaderText = "Aug";
                boundColumn.ColumnGroupName = "FQ4";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FM12";
                boundColumn.HeaderText = "Sep";
                boundColumn.ColumnGroupName = "FQ4";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
            }
            boundColumn = new GridBoundColumn();
            grdDynamic.MasterTableView.Columns.Add(boundColumn);
            boundColumn.DataField = "FQ4";
            boundColumn.HeaderText = "FQ4";
            if (blnDetailsByMonth)
            {
                boundColumn.ColumnGroupName = "FQ4";
            }
            else
            {
                boundColumn.ColumnGroupName = "FQs";
            }
            boundColumn.Aggregate = GridAggregateFunction.Sum;
            boundColumn.FooterAggregateFormatString = "{0}";
            boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
            boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
        }

        boundColumn = new GridBoundColumn();
        grdDynamic.MasterTableView.Columns.Add(boundColumn);
        boundColumn.DataField = "FY";
        boundColumn.HeaderText = "FY";
        boundColumn.Aggregate = GridAggregateFunction.Sum;
        boundColumn.FooterAggregateFormatString = "{0}";
        boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
        boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
        boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

        GridGroupByField field = new GridGroupByField();
        field.FieldName = "VISN";
        field.HeaderText = "VISN";
        field.SortOrder = GridSortOrder.Ascending;
        GridGroupByExpression ex = new GridGroupByExpression();
        ex.GroupByFields.Add(field);
        ex.SelectFields.Add(field);
        grdDynamic.MasterTableView.GroupByExpressions.Add(ex);

        grdDynamic.MasterTableView.ShowGroupFooter = true;
        grdDynamic.MasterTableView.FooterStyle.Font.Bold = true;

        foreach (GridDataItem item in grdDynamic.MasterTableView.Items)
        {
            if (item.ItemType == GridItemType.GroupHeader)
            {
                item.Cells[0].Controls.Clear();
            }
        }
        grdDynamic.DataSource = dtSurveys;
        grdDynamic.DataBind();

        this.plchldrForDynamicGrid.Controls.Add(grdDynamic);
    }*/
    
    private void CreateDynamicGrid()
    {
        grdDynamic = new RadGrid();
        grdDynamic.ID = "grdDynamic";
        grdDynamic.MasterTableView.EnableColumnsViewState = false;
        grdDynamic.Skin = strSkin;
        grdDynamic.AutoGenerateColumns = false;
        grdDynamic.GroupingEnabled = true;
        grdDynamic.ShowFooter = true;
        grdDynamic.ShowGroupPanel = false;
        grdDynamic.Visible = true;
        grdDynamic.Width = Unit.Percentage(100);

        GridColumnGroup cg;
        GridBoundColumn boundColumn;

        #region columns for Main report

        if ((surveyType != 8) && (surveyType != 10)){
            cg = new GridColumnGroup();
            cg.Name = "FQs";
            cg.HeaderText = "Fiscal Quarters";
            cg.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            grdDynamic.MasterTableView.ColumnGroups.Add(cg);

            if (selectedFQs.Contains("1") && (blnDetailsByMonth))
            {
                cg = new GridColumnGroup();
                cg.Name = "FQ1";
                cg.HeaderText = "FQ1";
                cg.ParentGroupName = "FQs";
                cg.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                grdDynamic.MasterTableView.ColumnGroups.Add(cg);
            }

            if (selectedFQs.Contains("2") && (blnDetailsByMonth))
            {
                cg = new GridColumnGroup();
                cg.Name = "FQ2";
                cg.HeaderText = "FQ2";
                cg.ParentGroupName = "FQs";
                cg.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                grdDynamic.MasterTableView.ColumnGroups.Add(cg);
            }

            if (selectedFQs.Contains("3") && (blnDetailsByMonth))
            {
                cg = new GridColumnGroup();
                cg.Name = "FQ3";
                cg.HeaderText = "FQ3";
                cg.ParentGroupName = "FQs";
                cg.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                grdDynamic.MasterTableView.ColumnGroups.Add(cg);
            }

            if (selectedFQs.Contains("4") && (blnDetailsByMonth))
            {
                cg = new GridColumnGroup();
                cg.Name = "FQ4";
                cg.HeaderText = "FQ4";
                cg.ParentGroupName = "FQs";
                cg.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                grdDynamic.MasterTableView.ColumnGroups.Add(cg);
            }

            boundColumn = new GridBoundColumn();
            grdDynamic.MasterTableView.Columns.Add(boundColumn);
            boundColumn.DataField = "Facility";
            boundColumn.HeaderText = "Facility";
            boundColumn.Aggregate = GridAggregateFunction.Count;
            boundColumn.FooterAggregateFormatString = "Total: {0}";
            boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Left;

            if (selectedFQs.Contains("1"))
            {
                if (blnDetailsByMonth)
                {
                    boundColumn = new GridBoundColumn();
                    grdDynamic.MasterTableView.Columns.Add(boundColumn);
                    boundColumn.DataField = "FM1";
                    boundColumn.HeaderText = "Oct";
                    boundColumn.ColumnGroupName = "FQ1";
                    boundColumn.Aggregate = GridAggregateFunction.Sum;
                    boundColumn.FooterAggregateFormatString = "{0}";
                    boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                    boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                    boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

                    boundColumn = new GridBoundColumn();
                    grdDynamic.MasterTableView.Columns.Add(boundColumn);
                    boundColumn.DataField = "FM2";
                    boundColumn.HeaderText = "Nov";
                    boundColumn.ColumnGroupName = "FQ1";
                    boundColumn.Aggregate = GridAggregateFunction.Sum;
                    boundColumn.FooterAggregateFormatString = "{0}";
                    boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                    boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                    boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

                    boundColumn = new GridBoundColumn();
                    grdDynamic.MasterTableView.Columns.Add(boundColumn);
                    boundColumn.DataField = "FM3";
                    boundColumn.HeaderText = "Dec";
                    boundColumn.ColumnGroupName = "FQ1";
                    boundColumn.Aggregate = GridAggregateFunction.Sum;
                    boundColumn.FooterAggregateFormatString = "{0}";
                    boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                    boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                    boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
                }

                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FQ1";
                boundColumn.HeaderText = "FQ1";
                if (blnDetailsByMonth)
                {
                    boundColumn.ColumnGroupName = "FQ1";
                }
                else
                {
                    boundColumn.ColumnGroupName = "FQs";
                }
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
            }

            if (selectedFQs.Contains("2"))
            {
                if (blnDetailsByMonth)
                {
                    boundColumn = new GridBoundColumn();
                    grdDynamic.MasterTableView.Columns.Add(boundColumn);
                    boundColumn.DataField = "FM4";
                    boundColumn.HeaderText = "Jan";
                    boundColumn.ColumnGroupName = "FQ2";
                    boundColumn.Aggregate = GridAggregateFunction.Sum;
                    boundColumn.FooterAggregateFormatString = "{0}";
                    boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                    boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                    boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

                    boundColumn = new GridBoundColumn();
                    grdDynamic.MasterTableView.Columns.Add(boundColumn);
                    boundColumn.DataField = "FM5";
                    boundColumn.HeaderText = "Feb";
                    boundColumn.ColumnGroupName = "FQ2";
                    boundColumn.Aggregate = GridAggregateFunction.Sum;
                    boundColumn.FooterAggregateFormatString = "{0}";
                    boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                    boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                    boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

                    boundColumn = new GridBoundColumn();
                    grdDynamic.MasterTableView.Columns.Add(boundColumn);
                    boundColumn.DataField = "FM6";
                    boundColumn.HeaderText = "Mar";
                    boundColumn.ColumnGroupName = "FQ2";
                    boundColumn.Aggregate = GridAggregateFunction.Sum;
                    boundColumn.FooterAggregateFormatString = "{0}";
                    boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                    boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                    boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
                }
                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FQ2";
                boundColumn.HeaderText = "FQ2";
                if (blnDetailsByMonth)
                {
                    boundColumn.ColumnGroupName = "FQ2";
                }
                else
                {
                    boundColumn.ColumnGroupName = "FQs";
                }
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
            }

            if (selectedFQs.Contains("3"))
            {
                if (blnDetailsByMonth)
                {
                    boundColumn = new GridBoundColumn();
                    grdDynamic.MasterTableView.Columns.Add(boundColumn);
                    boundColumn.DataField = "FM7";
                    boundColumn.HeaderText = "Apr";
                    boundColumn.ColumnGroupName = "FQ3";
                    boundColumn.Aggregate = GridAggregateFunction.Sum;
                    boundColumn.FooterAggregateFormatString = "{0}";
                    boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                    boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                    boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

                    boundColumn = new GridBoundColumn();
                    grdDynamic.MasterTableView.Columns.Add(boundColumn);
                    boundColumn.DataField = "FM8";
                    boundColumn.HeaderText = "May";
                    boundColumn.ColumnGroupName = "FQ3";
                    boundColumn.Aggregate = GridAggregateFunction.Sum;
                    boundColumn.FooterAggregateFormatString = "{0}";
                    boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                    boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                    boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

                    boundColumn = new GridBoundColumn();
                    grdDynamic.MasterTableView.Columns.Add(boundColumn);
                    boundColumn.DataField = "FM9";
                    boundColumn.HeaderText = "Jun";
                    boundColumn.ColumnGroupName = "FQ3";
                    boundColumn.Aggregate = GridAggregateFunction.Sum;
                    boundColumn.FooterAggregateFormatString = "{0}";
                    boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                    boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                    boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
                }
                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FQ3";
                boundColumn.HeaderText = "FQ3";
                if (blnDetailsByMonth)
                {
                    boundColumn.ColumnGroupName = "FQ3";
                }
                else
                {
                    boundColumn.ColumnGroupName = "FQs";
                }
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
            }

            if (selectedFQs.Contains("4"))
            {
                if (blnDetailsByMonth)
                {
                    boundColumn = new GridBoundColumn();
                    grdDynamic.MasterTableView.Columns.Add(boundColumn);
                    boundColumn.DataField = "FM10";
                    boundColumn.HeaderText = "Jul";
                    boundColumn.ColumnGroupName = "FQ4";
                    boundColumn.Aggregate = GridAggregateFunction.Sum;
                    boundColumn.FooterAggregateFormatString = "{0}";
                    boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                    boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                    boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

                    boundColumn = new GridBoundColumn();
                    grdDynamic.MasterTableView.Columns.Add(boundColumn);
                    boundColumn.DataField = "FM11";
                    boundColumn.HeaderText = "Aug";
                    boundColumn.ColumnGroupName = "FQ4";
                    boundColumn.Aggregate = GridAggregateFunction.Sum;
                    boundColumn.FooterAggregateFormatString = "{0}";
                    boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                    boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                    boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

                    boundColumn = new GridBoundColumn();
                    grdDynamic.MasterTableView.Columns.Add(boundColumn);
                    boundColumn.DataField = "FM12";
                    boundColumn.HeaderText = "Sep";
                    boundColumn.ColumnGroupName = "FQ4";
                    boundColumn.Aggregate = GridAggregateFunction.Sum;
                    boundColumn.FooterAggregateFormatString = "{0}";
                    boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                    boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                    boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
                }
                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FQ4";
                boundColumn.HeaderText = "FQ4";
                if (blnDetailsByMonth)
                {
                    boundColumn.ColumnGroupName = "FQ4";
                }
                else
                {
                    boundColumn.ColumnGroupName = "FQs";
                }
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
            }

            boundColumn = new GridBoundColumn();
            grdDynamic.MasterTableView.Columns.Add(boundColumn);
            boundColumn.DataField = "FY";
            boundColumn.HeaderText = "FY";
            boundColumn.Aggregate = GridAggregateFunction.Sum;
            boundColumn.FooterAggregateFormatString = "{0}";
            boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
            boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

            GridGroupByField field = new GridGroupByField();
            field.FieldName = "VISN";
            field.HeaderText = "VISN";
            field.SortOrder = GridSortOrder.Ascending;
            GridGroupByExpression ex = new GridGroupByExpression();
            ex.GroupByFields.Add(field);
            ex.SelectFields.Add(field);
            grdDynamic.MasterTableView.GroupByExpressions.Add(ex);

            grdDynamic.MasterTableView.ShowGroupFooter = true;
            grdDynamic.MasterTableView.FooterStyle.Font.Bold = true;
        }
        #endregion 


        #region columns for LCI-5 report
        
        if (surveyType == 8)
        {
            cg = new GridColumnGroup();
            cg.Name = "FQs";
            cg.HeaderText = "Fiscal Quarters";
            cg.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            grdDynamic.MasterTableView.ColumnGroups.Add(cg);

            boundColumn = new GridBoundColumn();
            grdDynamic.MasterTableView.Columns.Add(boundColumn);
            boundColumn.DataField = "Facility";
            boundColumn.HeaderText = "Facility";
            boundColumn.Aggregate = GridAggregateFunction.Count;
            boundColumn.FooterAggregateFormatString = "Total: {0}";
            boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Left;

            if (selectedFQs.Contains("1"))
            {
                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FQ1";
                boundColumn.HeaderText = "FQ1";
                boundColumn.ColumnGroupName = "FQs";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
            }
            if (selectedFQs.Contains("2"))
            {
                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FQ2";
                boundColumn.HeaderText = "FQ2";
                boundColumn.ColumnGroupName = "FQs";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
            }
            if (selectedFQs.Contains("3"))
            {
                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FQ3";
                boundColumn.HeaderText = "FQ3";
                boundColumn.ColumnGroupName = "FQs";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
            }
            if (selectedFQs.Contains("4"))
            {
                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FQ4";
                boundColumn.HeaderText = "FQ4";
                boundColumn.ColumnGroupName = "FQs";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
            }

            boundColumn = new GridBoundColumn();
            grdDynamic.MasterTableView.Columns.Add(boundColumn);
            boundColumn.DataField = "FY";
            boundColumn.HeaderText = "FY";
            boundColumn.Aggregate = GridAggregateFunction.Sum;
            boundColumn.FooterAggregateFormatString = "{0}";
            boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
            boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

            boundColumn = new GridBoundColumn();
            grdDynamic.MasterTableView.Columns.Add(boundColumn);
            boundColumn.DataField = "BASIC-AVG";
            boundColumn.HeaderText = "FY Avg. Basic Score";
            //boundColumn.Aggregate = GridAggregateFunction.Sum;
            boundColumn.DataFormatString = "{0:### ##0.00}";
            boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
            boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

            boundColumn = new GridBoundColumn();
            grdDynamic.MasterTableView.Columns.Add(boundColumn);
            boundColumn.DataField = "ADV-AVG";
            boundColumn.HeaderText = "FY Avg. Adv. Score";
            //boundColumn.Aggregate = GridAggregateFunction.Sum;
            boundColumn.DataFormatString = "{0:### ##0.00}";
            boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
            boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

            boundColumn = new GridBoundColumn();
            grdDynamic.MasterTableView.Columns.Add(boundColumn);
            boundColumn.DataField = "TOTAL-AVG";
            boundColumn.HeaderText = "FY Total Score";
            //boundColumn.Aggregate = GridAggregateFunction.Sum;
            boundColumn.DataFormatString = "{0:### ##0.00}";
            boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
            boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

            GridGroupByField field = new GridGroupByField();
            field.FieldName = "VISN";
            field.HeaderText = "VISN";
            field.SortOrder = GridSortOrder.Ascending;
            GridGroupByExpression ex = new GridGroupByExpression();
            ex.GroupByFields.Add(field);
            ex.SelectFields.Add(field);
            grdDynamic.MasterTableView.GroupByExpressions.Add(ex);

            grdDynamic.MasterTableView.ShowGroupFooter = true;
            grdDynamic.MasterTableView.FooterStyle.Font.Bold = true;
        }
        #endregion

        #region columns for PGIC report
        
        if (surveyType == 10)
        {
            cg = new GridColumnGroup();
            cg.Name = "FQs";
            cg.HeaderText = "Fiscal Quarters";
            cg.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            grdDynamic.MasterTableView.ColumnGroups.Add(cg);

            boundColumn = new GridBoundColumn();
            grdDynamic.MasterTableView.Columns.Add(boundColumn);
            boundColumn.DataField = "Facility";
            boundColumn.HeaderText = "Facility";
            boundColumn.Aggregate = GridAggregateFunction.Count;
            boundColumn.FooterAggregateFormatString = "Total: {0}";
            boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Left;

            if (selectedFQs.Contains("1"))
            {
                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FQ1";
                boundColumn.HeaderText = "FQ1";
                boundColumn.ColumnGroupName = "FQs";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
            }
            if (selectedFQs.Contains("2"))
            {
                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FQ2";
                boundColumn.HeaderText = "FQ2";
                boundColumn.ColumnGroupName = "FQs";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
            }
            if (selectedFQs.Contains("3"))
            {
                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FQ3";
                boundColumn.HeaderText = "FQ3";
                boundColumn.ColumnGroupName = "FQs";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
            }
            if (selectedFQs.Contains("4"))
            {
                boundColumn = new GridBoundColumn();
                grdDynamic.MasterTableView.Columns.Add(boundColumn);
                boundColumn.DataField = "FQ4";
                boundColumn.HeaderText = "FQ4";
                boundColumn.ColumnGroupName = "FQs";
                boundColumn.Aggregate = GridAggregateFunction.Sum;
                boundColumn.FooterAggregateFormatString = "{0}";
                boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
                boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
                boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
            }

            boundColumn = new GridBoundColumn();
            grdDynamic.MasterTableView.Columns.Add(boundColumn);
            boundColumn.DataField = "FY";
            boundColumn.HeaderText = "FY";
            boundColumn.Aggregate = GridAggregateFunction.Sum;
            boundColumn.FooterAggregateFormatString = "{0}";
            boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
            boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;

            boundColumn = new GridBoundColumn();
            grdDynamic.MasterTableView.Columns.Add(boundColumn);
            boundColumn.DataField = "FY-AVG";
            boundColumn.HeaderText = "FY Avg. Score";
            //boundColumn.Aggregate = GridAggregateFunction.Sum;
            boundColumn.DataFormatString = "{0:### ##0.00}";
            boundColumn.ItemStyle.HorizontalAlign = HorizontalAlign.Right;
            boundColumn.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            boundColumn.FooterStyle.HorizontalAlign = HorizontalAlign.Right;
            
            GridGroupByField field = new GridGroupByField();
            field.FieldName = "VISN";
            field.HeaderText = "VISN";
            field.SortOrder = GridSortOrder.Ascending;
            GridGroupByExpression ex = new GridGroupByExpression();
            ex.GroupByFields.Add(field);
            ex.SelectFields.Add(field);
            grdDynamic.MasterTableView.GroupByExpressions.Add(ex);
            grdDynamic.MasterTableView.ShowGroupFooter = true;
            grdDynamic.MasterTableView.FooterStyle.Font.Bold = true;
        }
        #endregion

        //grdDynamic.MasterTableView.ExpandCollapseColumn.Visible = false;
        //foreach (GridDataItem item in grdDynamic.MasterTableView.Items)
        //{
        //    if (item.ItemType == GridItemType.GroupHeader)
        //    {
        //        item.Cells[0].Controls.Clear();
        //    }
        //}
        grdDynamic.DataSource = dtSurveys;
        grdDynamic.DataBind();
        this.plchldrForDynamicGrid.Controls.Add(grdDynamic);
    }

    protected void grdSurveys_ItemCreated(object sender, GridItemEventArgs e) {
        if (e.Item is GridGroupHeaderItem) {
            GridGroupHeaderItem item = (GridGroupHeaderItem)e.Item;
            DataRowView groupDataRow = (DataRowView)e.Item.DataItem;
            item.Cells[0].Controls.Clear();
        }
    }

    public DataTable GetFiscalYears() {
        return SqlProvider.ExecuteSPDataTable(Globals.GetConnectionName, GET_FISCAL_YEARS, new object[] { });
    }

    public DataTable GetInstrumentTypes()
    {
        return SqlProvider.ExecuteSPDataTable(Globals.GetConnectionName, GET_INSTRUMENT_TYPES, new object[] { });
    }
    
    public DataTable GetSurveysData(int surveyType) {
        DataTable dt = null;

        //var FY = ddlFY.SelectedValue;
        //if (ddlFY.SelectedIndex == 0) FY = null;
        var vDisplayMode = rblDisplayMode.SelectedValue;
        ////if (trDisplayMode.Visible == false)
        ////{
        ////    vDisplayMode = "0";
        ////}
        if (FY != -1 && surveyType != 0) {
            try {
                //DateTime dtQ1Start = (DateTime)SqlProvider.ExecuteScalar(Globals.GetConnectionName, GET_FQ_FIRST_DAY, new object[] { FY, 1 });
                //DateTime dtQ2Start = (DateTime)SqlProvider.ExecuteScalar(Globals.GetConnectionName, GET_FQ_FIRST_DAY, new object[] { FY, 2 });
                //DateTime dtQ3Start = (DateTime)SqlProvider.ExecuteScalar(Globals.GetConnectionName, GET_FQ_FIRST_DAY, new object[] { FY, 3 });
                //DateTime dtQ4Start = (DateTime)SqlProvider.ExecuteScalar(Globals.GetConnectionName, GET_FQ_FIRST_DAY, new object[] { FY, 4 });

                //DateTime dtQ1End = (DateTime)SqlProvider.ExecuteScalar(Globals.GetConnectionName, GET_FQ_LAST_DAY, new object[] { FY, 1 });
                //DateTime dtQ2End = (DateTime)SqlProvider.ExecuteScalar(Globals.GetConnectionName, GET_FQ_LAST_DAY, new object[] { FY, 2 });
                //DateTime dtQ3End = (DateTime)SqlProvider.ExecuteScalar(Globals.GetConnectionName, GET_FQ_LAST_DAY, new object[] { FY, 3 });
                //DateTime dtQ4End = (DateTime)SqlProvider.ExecuteScalar(Globals.GetConnectionName, GET_FQ_LAST_DAY, new object[] { FY, 4 });

                //return SqlProvider.ExecuteSPDataTable(Globals.GetConnectionName, GET_SURVEYS, new object[] { });
                //dt = SqlProvider.ExecuteSPDataTable(Globals.GetConnectionName, GET_SURVEYS, new object[] { surveyType, dtQ1Start, dtQ2Start, dtQ3Start, dtQ4Start, dtQ1End, dtQ2End, dtQ3End, dtQ4End, vDisplayMode });

                dt = SqlProvider.ExecuteSPDataTable(Globals.GetConnectionName, GET_SURVEYS, new object[] { surveyType, vDisplayMode, FY });
            } catch (Exception ex) { }
        }
        return dt;
    }

    protected void ImageButton_Click(object sender, ImageClickEventArgs e) 
    {
        GenerateReport();

        string alternateText = string.Empty;

        ImageButton btn = sender as ImageButton;
        //if (btn != null)
        //    alternateText = btn.AlternateText;

        //////int surveyType;
        //////int.TryParse(ddlTBIInstruments.SelectedValue, out surveyType);
        //////string exportTitle = ((ddlTBIInstruments.SelectedItem != null) ? ddlTBIInstruments.SelectedItem.Text : "") + " Report: Fiscal Year (" + ddlFY.SelectedValue + ")";

        //if ((surveyType != 8) && (surveyType != 10)) {
        //    //grdSurveys.ExportSettings.Excel.Format = (GridExcelExportFormat)Enum.Parse(typeof(GridExcelExportFormat), alternateText);
        //    ////grdSurveys.MasterTableView.Controls.Add(new LiteralControl("<span><br/>Description: Data selected using dates between 1 Jan 2011 to 1 Sep 2011</span>"));
        //    //grdSurveys.MasterTableView.Caption = "<span><strong><br/>" + exportTitle + "<strong></span>";
        //    //grdSurveys.ExportSettings.IgnorePaging = true;
        //    //grdSurveys.ExportSettings.ExportOnlyData = false;
        //    //grdSurveys.ExportSettings.OpenInNewWindow = true;
        //    //grdSurveys.MasterTableView.ExportToExcel();
        //    grdDynamic.ExportSettings.Excel.Format = (GridExcelExportFormat)Enum.Parse(typeof(GridExcelExportFormat), alternateText);
        //    grdDynamic.MasterTableView.Caption = "<span><strong><br/>" + exportTitle + "<strong></span>";
        //    grdDynamic.ExportSettings.IgnorePaging = true;
        //    grdDynamic.ExportSettings.ExportOnlyData = false;
        //    grdDynamic.ExportSettings.OpenInNewWindow = true;
        //    grdDynamic.MasterTableView.ExportToExcel();
        //}
        //else if (surveyType == 8)
        //{
        //    //grdSurveys_ST8.ExportSettings.Excel.Format = (GridExcelExportFormat)Enum.Parse(typeof(GridExcelExportFormat), alternateText);
        //    //grdSurveys_ST8.MasterTableView.Caption = "<span><strong><br/>" + exportTitle + "<strong></span>";
        //    //grdSurveys_ST8.ExportSettings.IgnorePaging = true;
        //    //grdSurveys_ST8.ExportSettings.ExportOnlyData = false;
        //    //grdSurveys_ST8.ExportSettings.OpenInNewWindow = true;
        //    //grdSurveys_ST8.MasterTableView.ExportToExcel();
        //    grdDynamic.ExportSettings.Excel.Format = (GridExcelExportFormat)Enum.Parse(typeof(GridExcelExportFormat), alternateText);
        //    grdDynamic.MasterTableView.Caption = "<span><strong><br/>" + exportTitle + "<strong></span>";
        //    grdDynamic.ExportSettings.IgnorePaging = true;
        //    grdDynamic.ExportSettings.ExportOnlyData = false;
        //    grdDynamic.ExportSettings.OpenInNewWindow = true;
        //    grdDynamic.MasterTableView.ExportToExcel();
        //}
        //else if (surveyType == 10)
        //{
        //    //grdSurveys_ST10.ExportSettings.Excel.Format = (GridExcelExportFormat)Enum.Parse(typeof(GridExcelExportFormat), alternateText);
        //    //grdSurveys_ST10.MasterTableView.Caption = "<span><strong><br/>" + exportTitle + "<strong></span>";
        //    //grdSurveys_ST10.ExportSettings.IgnorePaging = true;
        //    //grdSurveys_ST10.ExportSettings.ExportOnlyData = false;
        //    //grdSurveys_ST10.ExportSettings.OpenInNewWindow = true;
        //    //grdSurveys_ST10.MasterTableView.ExportToExcel();
        //    grdDynamic.ExportSettings.Excel.Format = (GridExcelExportFormat)Enum.Parse(typeof(GridExcelExportFormat), alternateText);
        //    grdDynamic.MasterTableView.Caption = "<span><strong><br/>" + exportTitle + "<strong></span>";
        //    grdDynamic.ExportSettings.IgnorePaging = true;
        //    grdDynamic.ExportSettings.ExportOnlyData = false;
        //    grdDynamic.ExportSettings.OpenInNewWindow = true;
        //    grdDynamic.MasterTableView.ExportToExcel();
        //}

    }

    protected void RadGrid1_HtmlExporting(object sender, GridHTMLExportingEventArgs e) {
        e.Styles.Append("@page table .employeeColumn { background-color: #d3d3d3; }");
    }

    /// <summary>
    /// Create LCI-5 Report
    /// </summary>
    /// <param name="fiscalYear"></param>
    /// <param name="displayMode"></param>
    protected void getLCI5Report(int fiscalYear, int displayMode) {
        //using (RegistriesDataAccess db = new RegistriesDataAccess()) {
            /*
            db.CommandTimeout = 100;

            #region  get fiscal quarter start dates

            DateTime fyQ1Start = (from d in db.DimTimes
                                  where d.Fiscal_Year_Name.EndsWith(fiscalYear.ToString()) && d.Fiscal_Quarter_Of_Year == 1 && d.Fiscal_Day_Of_Quarter == 1
                                  select d.PK_Date).FirstOrDefault();

            DateTime fyQ2Start = (from d in db.DimTimes
                                  where d.Fiscal_Year_Name.EndsWith(fiscalYear.ToString()) && d.Fiscal_Quarter_Of_Year == 2 && d.Fiscal_Day_Of_Quarter == 1
                                  select d.PK_Date).FirstOrDefault();

            DateTime fyQ3Start = (from d in db.DimTimes
                                  where d.Fiscal_Year_Name.EndsWith(fiscalYear.ToString()) && d.Fiscal_Quarter_Of_Year == 3 && d.Fiscal_Day_Of_Quarter == 1
                                  select d.PK_Date).FirstOrDefault();

            DateTime fyQ4Start = (from d in db.DimTimes
                                  where d.Fiscal_Year_Name.EndsWith(fiscalYear.ToString()) && d.Fiscal_Quarter_Of_Year == 4 && d.Fiscal_Day_Of_Quarter == 1
                                  select d.PK_Date).FirstOrDefault();

            #endregion

            #region  get fiscal quarter end dates

            DateTime fyQ1End = (from d in db.DimTimes
                                where d.Fiscal_Year_Name.EndsWith(fiscalYear.ToString()) && d.Fiscal_Quarter_Of_Year == 1
                                orderby d.PK_Date descending
                                select d.PK_Date).FirstOrDefault();

            DateTime fyQ2End = (from d in db.DimTimes
                                where d.Fiscal_Year_Name.EndsWith(fiscalYear.ToString()) && d.Fiscal_Quarter_Of_Year == 2
                                orderby d.PK_Date descending
                                select d.PK_Date).FirstOrDefault();

            DateTime fyQ3End = (from d in db.DimTimes
                                where d.Fiscal_Year_Name.EndsWith(fiscalYear.ToString()) && d.Fiscal_Quarter_Of_Year == 3
                                orderby d.PK_Date descending
                                select d.PK_Date).FirstOrDefault();

            DateTime fyQ4End = (from d in db.DimTimes
                                where d.Fiscal_Year_Name.EndsWith(fiscalYear.ToString()) && d.Fiscal_Quarter_Of_Year == 4
                                orderby d.PK_Date descending
                                select d.PK_Date).FirstOrDefault();

            #endregion

            var allEntries = from results in db.SURVEY_RESULTs
                         join choices in db.STD_QUESTION_CHOICEs on results.STD_QUESTION_CHOICE_ID equals choices.STD_QUESTION_CHOICE_ID // join question choices
                         join question in db.STD_QUESTIONs on choices.STD_QUESTION_ID equals question.ID // join question
                         join survey in db.SURVEYs on results.SURVEYS_ID equals survey.SURVEYS_ID // join survey
                         join institution in db.STD_INSTITUTIONs on survey.STD_INSTITUTION_ID equals institution.ID // join institution
                         join visnInst in db.STD_INSTITUTIONs on institution.VISN_ID equals visnInst.ID // join inst again for VISN name

                         where survey.STD_SURVEY_TYPE_ID == 8 && survey.SURVEY_STATUS == "completed" && (question.QUESTION_NUMBER == "15" || question.QUESTION_NUMBER == "16" || question.QUESTION_NUMBER == "17")

                         select new { 
                             VisnShort = visnInst.NAME, 
                             sta3n = institution.STATIONNUMBER, 
                             facilityName = institution.NAME, 
                             surveyDate = survey.SURVEY_DATE,
                             surveyId = survey.SURVEYS_ID,
                             questionNum = question.QUESTION_NUMBER,
                             resultValue = results.RESULT_TEXT
                         };


            // get distinct by surveyId
            var distinctBySurveyQuestionNum = from dist in allEntries
                                   group dist by new { dist.surveyId, dist.questionNum } into distSurv
                                   select new { 
                                       Id = distSurv.Key.surveyId,
                                       Quest = distSurv.Key.questionNum,
                                       FQ1 = distSurv.Sum(f => (f.surveyDate >= fyQ1Start && f.surveyDate <= fyQ1End) ? 1 : 0),
                                       FQ2 = distSurv.Sum(f => (f.surveyDate >= fyQ2Start && f.surveyDate <= fyQ2End) ? 1 : 0),
                                       FQ3 = distSurv.Sum(f => (f.surveyDate >= fyQ3Start && f.surveyDate <= fyQ3End) ? 1 : 0),
                                       FQ4 = distSurv.Sum(f => (f.surveyDate >= fyQ4Start && f.surveyDate <= fyQ4End) ? 1 : 0),
                                       AverageScore = distSurv.Average(f => (f.resultValue != null) ? Convert.ToDecimal(f.resultValue) : 0)
                                   };

            var distinctBySurvey = from d in distinctBySurveyQuestionNum
                                   group d by new {d.Id, d.FQ1, d.FQ2, d.FQ3, d.FQ4 } into distSurv
                                   select new {
                                       Survey = distSurv.Key.Id,
                                       FQ1 = distSurv.Key.FQ1,
                                       FQ2 = distSurv.Key.FQ2,
                                       FQ3 = distSurv.Key.FQ3,
                                       FQ4 = distSurv.Key.FQ4,
                                       Quests = distSurv.Select(d2 => new { Question = d2.Quest, Value = d2.AverageScore }).ToArray()
                                   };
            */

            //foreach (var entry in distinctBySurvey) {
            //    var temp = new { Survey = entry.Survey, FQ1 = entry.FQ1, FQ2 = entry.FQ2, FQ3 = entry.FQ3, FQ4 = entry.FQ4, BasicScore = 0, AdvancedScore = 0, TotalScore = 0 };

            //    //temp.Survey = entry.Survey;
            //    //temp.FQ1 = entry.FQ1;
            //    //temp.FQ2 = entry.FQ2;
            //    //temp.FQ3 = entry.FQ3;
            //    //temp.FQ4 = entry.FQ4;
            //}

            // check the fiscal dates against the survey date for count


                        //LEFT JOIN (SELECT SR.SURVEYS_ID, CAST(SR.RESULT_TEXT AS DECIMAL(8,2)) AS 'BasicScore'
                        //FROM SURVEY_RESULTS SR 
                        //JOIN STD_QUESTION_CHOICE QC ON SR.STD_QUESTION_CHOICE_ID = QC.STD_QUESTION_CHOICE_ID
                        //JOIN STD_QUESTION Q ON QC.STD_QUESTION_ID = Q.ID 
                        //WHERE Q.STD_SURVEY_TYPE_ID = 8 AND Q.QUESTION_NUMBER = '15') BasicScores ON S.SURVEYS_ID = BasicScores.SURVEYS_ID

            //var grouped = from t in testMe
            //              group t by new { t.VisnShort, t.sta3n } into g
            //              select new {
            //                  Visn = g.Key.VisnShort,
            //                  Sta3n = g.Key.sta3n,
            //                  FQ1 = g.Sum(f => (f.surveyDate >= fyQ1Start && f.surveyDate <= fyQ1End) ? 1 : 0),
            //                  FQ2 = g.Sum(f => (f.surveyDate >= fyQ2Start && f.surveyDate <= fyQ2End) ? 1 : 0),
            //                  FQ3 = g.Sum(f => (f.surveyDate >= fyQ3Start && f.surveyDate <= fyQ3End) ? 1 : 0),
            //                  FQ4 = g.Sum(f => (f.surveyDate >= fyQ4Start && f.surveyDate <= fyQ4End) ? 1 : 0)
            //              };

            //string test = "";
        //}
    }

    #region [ EXCELML FORMAT ]

    protected void RadGrid1_ExcelMLWorkBookCreated(object sender, GridExcelMLWorkBookCreatedEventArgs e) {
        foreach (RowElement row in e.WorkBook.Worksheets[0].Table.Rows) {
            row.Cells[0].StyleValue = "Style1";
        }
        StyleElement style = new StyleElement("Style1");
        style.InteriorStyle.Pattern = InteriorPatternType.Solid;
        style.InteriorStyle.Color = System.Drawing.Color.LightGray;
        e.WorkBook.Styles.Add(style);


        RowElement FYRow = new RowElement();
        FYRow.Cells[0].Data.DataItem = "TEST ME - 2014";

        e.WorkBook.Worksheets[0].Table.Rows.Insert(0, FYRow);
    }
    #endregion

    #region [ BIFF FORMAT ]

    protected void RadGrid1_BiffExporting(object sender, GridBiffExportingEventArgs e) {
        e.ExportStructure.Tables[0].Columns[1].Style.BackColor = System.Drawing.Color.LightGray;
    }

    #endregion
}
